import React, { useState } from 'react';

import { useDamagesConfig } from '../../../../../hooks/useDamagesConfig';
import { PictureGalleryControlItem } from '../../../../Photos/PictureGalleryControItem';
import { PictureGallery } from '../../../../PictureGallery';
import { DamagePhotoItem } from '../DamahePhotoItem';
import style from '../index.css';

interface IActualPhotoBlock {
    actualPhotos: any[];
}

export const ActualPhotoBlock = ((props: IActualPhotoBlock) => {
    const { actualPhotos = [] } = props;
    const [, configs] = useDamagesConfig();
    const [openedPhoto, setPhotoOpened] = useState(null);

    return actualPhotos.length
        ? <>
            {actualPhotos.map((photo, ind) => {
                return <DamagePhotoItem photo={photo}
                                        configs={configs}
                                        key={ind}
                                        onPhotoClick={setPhotoOpened.bind(null, ind)}/>;
            })
            }

            {openedPhoto !== null
                ? <PictureGallery initialIndex={openedPhoto ?? 0}
                                  onClose={setPhotoOpened.bind(null, null)}
                                  onChange={setPhotoOpened.bind(null)}
                                  controls={<PictureGalleryControlItem photo={actualPhotos?.[openedPhoto || 0]}/>}
                                  pictures={actualPhotos}/>
                : null
            }
        </>

        : <div className={style.no_photo}>Нет фото для разметки</div>;
});
