import React, { useState } from 'react';

import { Collapse2 } from '../../../../../ui/Collapse2';
import { PhotoItem } from '../../../../Photos/PhotoItem';
import { PictureGalleryControlItem } from '../../../../Photos/PictureGalleryControItem';
import { PictureGallery } from '../../../../PictureGallery';
import { hasLink } from '../constants';
import style from '../index.css';

interface IAdditionalPhotoBlock {
    additionalPhotos: any[];
}

export const AdditionalPhotoBlock = ((props: IAdditionalPhotoBlock) => {
    const { additionalPhotos = [] } = props;
    const [openedAdditionalPhoto, setAdditionalPhotoOpened] = useState(null);

    return additionalPhotos.length
        ? <>
            <div className={style.separator}/>

            <Collapse2 title={'Дополнительные фото'}
                       children={
                           <div className={style.additional_wrapper}>
                               {additionalPhotos.map((el, ind) => {
                                   const st = hasLink(el);
                                   const desc = <div className={style.photo_desc}>
                            Дубли: {el?.dups?.length}
                                       {st ? <div className={style.incident}>Инцидент</div> : null}
                                   </div>;

                                   return <div onClick={setAdditionalPhotoOpened.bind(null, ind)}
                                               key={el.image_id}
                                               className={style.additional_preview}>
                                       <PhotoItem photo={el} index={ind} children={desc}/>
                                   </div>;
                               })}
                           </div>
                       }/>

            {openedAdditionalPhoto !== null
                ? <PictureGallery initialIndex={openedAdditionalPhoto ?? 0}
                                  onClose={setAdditionalPhotoOpened.bind(null, null)}
                                  onChange={setAdditionalPhotoOpened.bind(null)}
                                  controls={<PictureGalleryControlItem photo={additionalPhotos
                                      ?.[openedAdditionalPhoto || 0]}/>}
                                  pictures={additionalPhotos}/>
                : null
            }
        </>
        : null;

});
