import React from 'react';

import { EMPTY_DATA } from '../../../../../constants';
import Checkbox from '../../../../../ui/Checkbox';
import { STLink } from '../DamahePhotoItem';
import style from '../index.css';

interface IDamagesPhotosHeader {
    links: any[];
    onlyActual: boolean;
    setOnlyActual: (onlyActual: boolean) => void;
    disableCheckbox?: boolean;
}

export const DamagesPhotosHeader = ((props: IDamagesPhotosHeader) => {
    const { links, onlyActual, setOnlyActual, disableCheckbox } = props;

    return <div className={style.damages_header}>
        <div>
            Ссылки:
            {links?.length
                ? links?.map((el, index) => {
                    return <span key={index}><STLink el={{ st_link: el }}/>; </span>;
                })
                : EMPTY_DATA
            }
        </div>

        <div className={style.checkbox}>
            <span>Только актуальные:</span>
            <Checkbox checked={onlyActual}
                      onChange={setOnlyActual.bind(null, !onlyActual)}
                      disabled={disableCheckbox}/>
        </div>
    </div>;
});
