export const Verdicts = {
    need_incident: 'требуется инцидент',
    already_has_incident: 'инцидент есть',
    no_need_incident: 'не требуется поиск виновника',
};

export const getArea = (configs, el) => {
    return configs?.areas?.find(_ => _.name === el.area)?.display || el.area;
};

export const getDamageLevel = (configs, el) => {
    return configs?.levels?.[el.area]?.find(_ => _.name === el.damage_level)?.display || el.damage_level;
};

export const getDescription = (configs, el) => {
    const descriptions = Object.entries(configs?.elements?.[el.area] || {});
    let description = el.description;
    descriptions.forEach(([key, value]) => {
        key = key?.replace(' ', '_');
        if (key === el.description) {
            description = value;

            return;
        }
    });

    return description;
};

export const formatLink = (link) => {
    const _arr = link.split('/');

    return _arr[_arr.length - 1];
};

export const getLinks = (images) => {
    return [...images?.reduce((_p, _c) => {
        getVerdictsWithLink(_c, (_) => _p.add(_.st_link));
        if (_c.dups?.length) {
            const links = getLinks(_c.dups);
            links.forEach(el => _p.add(el));
        }

        return _p;
    }, new Set())].sort();
};

export const reduceDups = (_p, _c) => {
    getVerdictsWithLink(_c, (_) => _p.push(_));

    return _p;
};

const getVerdictsWithLink = (_c, callback) => {
    _c?.meta_data?.support_verdicts?.forEach?.(el => {
        if (el.st_link) {
            callback(el);
        }
    });
};

export const filterPhotos = (photos, onlyActual, actualPhotosId) => {
    let actualPhotos: any[] = [];
    const markedPhotos: any[] = [];
    let additionalPhotos: any[] = [];

    if (actualPhotosId.length) {
        const IDS = {};

        actualPhotosId.forEach(el => {
            IDS[el.uri] = el;
        });

        photos.forEach(photo => {
            if (IDS[photo.image_id]) {
                actualPhotos.push(photo);
            } else {
                additionalPhotos.push(photo);
            }
        });
    } else {
        photos.forEach(el => {
            const hasTolokaMarkup = el?.mark_up_list?.length;
            const hasSupportVerdict = el?.meta_data?.support_verdicts;
            const hasDupsVerdicts = el?.dups?.some(el => el?.meta_data?.support_verdicts);
            const actualPhoto = hasTolokaMarkup && !hasSupportVerdict && !hasDupsVerdicts;

            if (actualPhoto) {
                actualPhotos.push(el);
            } else if (hasSupportVerdict) {
                markedPhotos.push(el);
            } else {
                additionalPhotos.push(el);
            }
        });
    }

    if (onlyActual) {
        additionalPhotos = [...markedPhotos, ...additionalPhotos];
    } else {
        actualPhotos = [...actualPhotos, ...markedPhotos];
    }

    return { actualPhotos, additionalPhotos };
};

export function hasLink(photo) {
    const dubsHasLinks = photo.dups?.some(el => hasLink(el));

    return photo.meta_data?.support_verdicts?.some(el => el.st_link) || dubsHasLinks;
}
