import React, { useContext, useEffect, useState } from 'react';

import { SimpleError } from '../../../SimpleError';
import Spin from '../../../Spin';
import { ChatsOutgoingContext } from '../../context';
import { ActualPhotoBlock } from './childrenElements/ActualPhotoBlock';
import { AdditionalPhotoBlock } from './childrenElements/AdditionalPhotoBlock';
import { DamagesPhotosHeader } from './childrenElements/DamagesPhotoHeader';
import { filterPhotos, getLinks } from './constants';

interface IDamagesPhotosViewProps {
    sessionId: string;
    actualPhotosId: {uri: string; type: string}[];
}

export const DamagesPhotosView = (props: IDamagesPhotosViewProps) => {
    const context: any = useContext(ChatsOutgoingContext);
    const [onlyActual, setOnlyActual] = useState(true);
    const links = getLinks(context.allDamagePhotos);
    const { actualPhotos, additionalPhotos } = filterPhotos(context?.allDamagePhotos, onlyActual, props.actualPhotosId);

    useEffect(() => {
        context?.getDamageData(props.sessionId);
        setOnlyActual(true);
    }, [props.sessionId]);

    return <div>
        {context?.damageDataError && <SimpleError error={context?.damageDataError}/>}

        {context?.damageDataIsLoading
            ? <Spin/>
            : <div>
                {actualPhotos?.length || additionalPhotos?.length
                    ? <DamagesPhotosHeader links={links}
                                           onlyActual={onlyActual}
                                           setOnlyActual={setOnlyActual}
                                           disableCheckbox={Boolean(props.actualPhotosId.length)}/>
                    : null
                }

                <ActualPhotoBlock actualPhotos={actualPhotos}/>

                <AdditionalPhotoBlock additionalPhotos={additionalPhotos}/>
            </div>
        }
    </div>;
};
