/* eslint-disable @typescript-eslint/no-unused-vars */
import React, { useState } from 'react';

import { EMPTY_DATA, ONE_SECOND } from '../../../../constants';
import FormatDate from '../../../../ui/FormatDate';
import LS from '../../../../utils/localStorage/localStorage';
import Img from '../../../Img';
import { PictureGallery } from '../../../PictureGallery';
import { RESPONSE_STATUSES } from '../../../SimpleError';
import style from './index.css';

interface ILeasingSupportItemProps {
    data: {
        alarm_raise_url: string;
        at: number;
        external_photo_url?: string;
        external_video_url?: string;
        photo_url?: string;
        type: string;
        video_url?: string;
    };
    chatId: string;
}

const TEST_PREFIX = 'tst-';
const PROD_PREFIX = 'signal-';

export const LeasingSupportItem = (props: ILeasingSupportItemProps) => {
    const { data, chatId } = props;
    const [openedPhoto, setPhotoOpened] = useState(null);

    const imgLinks = [
        { link: data?.photo_url || '' },
        { link: data?.external_photo_url || '' },
    ];
    const videoLinks = [
        { link: data?.video_url || '' },
        { link: data?.external_video_url || '' },
    ];

    const photoClick = (e, index) => {
        e?.stopPropagation();
        setPhotoOpened(index);
    };

    const warnUser = async () => {
        const ls = new LS();
        const url = `/${ls.envIsTesting() ? TEST_PREFIX : PROD_PREFIX}${data?.alarm_raise_url?.split('/api/')[1]}`;

        return fetch(url, {
            method: 'GET',
            referrerPolicy: 'origin-when-cross-origin',
            credentials: 'include',
        }).then((res) => {
            if (res?.status !== RESPONSE_STATUSES.CODE_200) {
                throw new Error(`${res?.status}: ${res?.statusText}`);
            }
        });
    };

    return <div className={style.leasing_support_item}>
        <div>
            <div><b>Время:</b> <FormatDate value={data?.at * ONE_SECOND} withSecond/></div>
            <div><b>Тип:</b> {data?.type ?? EMPTY_DATA}</div>
        </div>
        {/* todo: разкоммитить и убрать eslint-disable, когда доедет стримминг */}
        {/*<QuickActionButton showConfirm={false}*/}
        {/*                   id={chatId}*/}
        {/*                   className={style.warn_button}*/}
        {/*                   accept={warnUser.bind(null)}*/}
        {/*                   button={{*/}
        {/*                       children: 'Предупредить пользователя',*/}
        {/*                       basic: true,*/}
        {/*                   }}/>*/}
        <div className={style.media_wrapper}>
            <b>Фото:</b>
            <div className={style.media_block}>
                {imgLinks.map((img, ind) => {
                    return img.link
                        ? <div key={`${img}-${ind}`}
                               className={style.photo_item}
                               onClick={(e) => photoClick(e, ind)}>
                            <Img src={img.link}/>
                        </div>
                        : null;
                })}
            </div>
        </div>

        <div className={style.media_wrapper}>
            <b>Видео:</b>
            <div className={style.media_block}>
                {videoLinks.map((video, ind) => {
                    return video.link
                        ? <div key={`${video}-${ind}`} className={style.video_item}>
                            <video controls muted src={video.link}/>
                        </div>
                        : null;
                })}
            </div>
        </div>

        {openedPhoto !== null
            ? <PictureGallery initialIndex={openedPhoto ?? 0}
                              onClose={setPhotoOpened.bind(null, null)}
                              pictures={imgLinks.filter((img) => img.link)}/>
            : null}
    </div>;
};
