import { connect } from 'react-redux';

import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../../constants';
import { getRawSetting2 } from '../../../../utils/getRawSetting';
import { IStore } from '../../../App/store';
import { LongtermModal } from './component';

const LONGTERM_FILTER_KEY = 'longterm_filter';
const CARS_TAGS = `${GVARS_INTERFACE_ADMIN_PREFIX}.${LONGTERM_FILTER_KEY}`;

export interface IMapStateToProps {
    evolutions: any[];
    carTags: string;
}

export const mapStateToProps = (store: IStore): IMapStateToProps => {
    return {
        evolutions: store.AdminUser?.permissions?.evolutions,
        carTags: getRawSetting2(store, CARS_TAGS),
    };
};

export default connect(mapStateToProps)(LongtermModal);
