import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../../utils/request';

export enum REQUESTS {
    GET_ACTION = 'GET_ACTION',
    GET_CAR_LIST = 'GET_CAR_LIST',
    TAG_EVOLVE = 'TAG_EVOLVE',
}

export const CHAT_REQUESTS: IComponentRequest = {
    [REQUESTS.GET_ACTION]: {
        api: 'actions/list',
        cgiObj: {
            action_id: null,
        },
    },
    [REQUESTS.GET_CAR_LIST]: {
        api: 'car/list',
        cgiObj: {
            sensors: null,
            tags_filter: null,
        },
    },
    [REQUESTS.TAG_EVOLVE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'tag/evolve',
        cgiObj: {
            tag_id: null,
        },
    },
};
