import React, { useEffect, useState } from 'react';

import { ONE_SECOND } from '../../../constants';
import FormatDate from '../../../ui/FormatDate';
import { JsonModal } from '../../../ui/FullModal/JsonModal';
import { Link } from '../../../ui/Link';
import { Request2 } from '../../../utils/request';
import * as style from '../index.css';
import { requestConfigs, REQUESTS } from '../request';
import { CITY_TAGS, NEW_AUTO_TAG, PREP_MARK_TAG } from './constants';

interface ILongtermWidgetProps {
    selectedChatItem: any;
    longtermData: any;
    openEvolutionModal: () => void;
}

export const LongtermWidget = React.memo((props: ILongtermWidgetProps) => {
    const { selectedChatItem, longtermData, openEvolutionModal } = props;
    const request = new Request2({ requestConfigs });

    const [jsonOpen, setOpen] = useState(false);
    const [cityTag, setCityTag] = useState('');

    const isLongtermNewAuto = selectedChatItem?.tag_data?.tag?.includes(NEW_AUTO_TAG);
    const isLongtermPrep = selectedChatItem?.tag_data?.tag?.includes(PREP_MARK_TAG);
    const longtermOffer = longtermData?.Offer?.LongTermOffer;
    const since = longtermOffer?.Since / ONE_SECOND;
    const until = longtermOffer?.Until / ONE_SECOND;
    const childSeat = longtermOffer?.ChildSeat;
    const mileage = longtermOffer?.Mileage;
    const action_id = longtermData?.Offer?.BehaviourConstructorId ?? '';

    useEffect(() => {
        request.exec(REQUESTS.GET_ACTION, {
            queryParams: { action_id },
        })
            .then(response => {
                const tags = response?.report?.[0]?.action_meta?.offer_tags;
                const cityTag = tags.find(el => el.includes('city'));
                setCityTag(cityTag);
            });

        return () => {
            request.abort();
        };
    }, [action_id]);

    function getAutoLink() {
        const carId = longtermData?.CarId;

        return carId ? `${location.origin}${location.pathname}#/cars/${carId}/info` : '';
    }

    return <div>
        {longtermData
            ? <>
                <div className={`${style.longterm} ${isLongtermNewAuto ? style.new_back : style.progress_back}`}>
                    <div className={style.car_img_item}>
                        <img src={longtermOffer?.OfferImage}
                             alt={''}
                             className={style.car_img}/>
                    </div>
                    <div className={style.info_block}>
                        <div>
                            <div className={style.longterm_header}>{`Долгосрок ${CITY_TAGS[cityTag]?.ru ?? ''}`}</div>

                            <div className={style.longterm_title}>{longtermData?.Offer?.Name}</div>
                            <span>C <FormatDate value={since} onlyDate={true} className={style.date}/> </span>
                            <span>по <FormatDate value={until} onlyDate={true} className={style.date}/></span>

                            <div className={style.longterm_title}>Детали:</div>
                            <div>
                                Детское кресло: <span>{childSeat ? 'Да' : 'Нет'}</span>
                            </div>
                            <div>Пробег: {mileage} км</div>
                        </div>

                        <div className={style.prep_buttons}>
                            {isLongtermNewAuto
                                ? <Link onClick={openEvolutionModal.bind(null)}
                                        className={style.link}>
                                    Привязать
                                </Link>
                                : isLongtermPrep
                                    ? <div>
                                        <Link href={getAutoLink()} className={style.link} target={'_blank'}>
                                            Авто
                                        </Link>
                                        <Link onClick={openEvolutionModal.bind(null)}>
                                            Перепривязать
                                        </Link>
                                    </div>
                                    : null
                            }

                            <Link onClick={setOpen.bind(null, true)}>
                                JSON
                            </Link>
                        </div>
                    </div>
                </div>
            </>

            : null
        }

        {jsonOpen
            ? <JsonModal obj={longtermData.Offer.LongTermOffer} onClose={setOpen.bind(null, false)}/>
            : null
        }
    </div>;
});
