import React from 'react';

import { Confirm } from '../../ui/FullModal';
import { ytLogs } from '../../utils/sendLogs';
import { EVENT_TYPES } from '../../utils/sendLogs/eventTypes/eventTypes';
import { deepCopy } from '../../utils/utils';
import { _CHATS, NOTIFY_PERMISSION } from '../ChatsCommon/types';
import { FAV_ACTION, FAV_LINES_TYPES, FAVOURITES, FavouritesLines, IFavLineItem } from '../FavouritesLines';

interface IFavouriteLinesConformProps {
    openAddConfirm: (isOpen: boolean) => any;
    group: _CHATS;
    item: any;
}

export default class FavouriteLinesConfirm extends React.Component<IFavouriteLinesConformProps, any> {
    favLines = new FavouritesLines();
    private log = ytLogs.getInstance();

    onAcceptConfirm() {
        const { group, item, openAddConfirm } = this.props;
        const itemName = item && `${group}__${item.name}` || '';

        const _item = deepCopy(item);
        delete _item['chats_count'];

        const logData = { //log data for only dispatcher
            event_type: EVENT_TYPES.CLICK_BUTTON,
            button_name: FAVOURITES,
            meta: {
                fav_action: FAV_ACTION.ADD,
                type: FAV_LINES_TYPES.dispatcher,
                group,
                _item,
            },
        };

        if (!this.favLines.match(group || '', item?.name)) {
            const favItem: IFavLineItem = item && group
                ? {
                    display_name: item.display_name,
                    chats: {
                        urgent: item?.chats_count || 0,
                    },
                    type: FAV_LINES_TYPES.dispatcher,
                    group,
                }
                : {} as IFavLineItem;

            this.favLines.add(itemName, favItem);
            logData.meta.fav_action = FAV_ACTION.ADD;
            this.checkPermission();
            openAddConfirm(false);
        } else {
            itemName && this.favLines.remove(itemName);
            logData.meta.fav_action = FAV_ACTION.REMOVE;
            openAddConfirm(false);
        }

        this.log?.send({ data: logData });
    }

    checkPermission() {
        Notification.requestPermission((permission) => {
            if (permission === NOTIFY_PERMISSION.denied) {
                alert('Разрешите получать уведомления о новых чатиках');
            }
        });
    }

    render() {
        const { group, item, openAddConfirm } = this.props;

        return <Confirm onClose={openAddConfirm.bind(this, false)}
                        question={this.favLines.getConfirmQuestion(group, item?.name)}
                        error={null}
                        accept={this.onAcceptConfirm.bind(this)}/>;
    }
}
