import React from 'react';

import { isObjectEqual } from '../../utils/isObjectEqual';
import { FeedList } from '../ChatsCommon/FeedList';
import { FeedListItem } from '../ChatsCommon/FeedListItem/component';
import { ITasks, IToggle } from './component';

export interface ISelectedChatItem {
    id: null;
    originator: null;
    topic_link?: null;
    tag_data?: any;
}

interface IFeedProps extends IToggle, ITasks {
    selectedChatItem;
    selectChatItem: () => void;
    filterValue: string;
    feedIsLoading?: boolean;
}

interface IFeedState {
    selectedChatItem: ISelectedChatItem | null;
}

export class Feed extends React.Component<IFeedProps, IFeedState> {
    state: IFeedState = {
        selectedChatItem: null,
    };

    shouldComponentUpdate(nextProps: Readonly<IFeedProps>, nextState: Readonly<{}>, nextContext: any): boolean {
        return !isObjectEqual(nextProps, this.props) || !isObjectEqual(nextState, this.state);
    }

    render() {
        let tasks;
        const chatItem = this.props.selectedChatItem;
        if (this.props.menu) {
            tasks = this.props.menu
                && Object.entries(this.props.tasks?.outgoing?.[this.props.menu] || {})?.reduce((_p, _c) => {
                    if (this.props.subMenu) {
                        if (_c[0] === this.props.subMenu) {
                            _p = _p.concat(_c[1]);
                        }
                    } else {
                        _p = _p.concat(_c[1]);
                    }

                    return _p;
                }, [] as any) || [];
        } else {
            tasks = chatItem
                ? [{
                    last_message: chatItem?.last_message,
                    originator: chatItem?.originator,
                    topic_link: chatItem?.topic_link,
                    tag_data: chatItem?.tag_data,
                }]
                : null;
        }

        const filterValue = this.props.filterValue.toUpperCase();
        tasks = filterValue ? tasks.filter(el => el?.last_message?.text?.toUpperCase()?.includes(filterValue)) : tasks;
        tasks = tasks?.sort((el1, el2) => el1.tag_data?.tag_created - el2.tag_data?.tag_created);

        return this.props?.isOpen
            ? <FeedList data={tasks}
                        users={this.props.tasks?.users}
                        isLoading={this.props.feedIsLoading}
                        feedListItem={FeedListItem}
                        selectedChatItem={this.props.selectedChatItem}
                        selectChatItem={this.props.selectChatItem.bind(this)}/>
            : null;
    }
}
