import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';

import { getRawSetting2 } from '../../utils/getRawSetting';
import { IStore } from '../App/store';
import { DISPATCHER_LONGTERM_TAGS, DISPATCHER_SETTINGS } from '../InterfaceAdminConfig/adminConfigKeys';
import { ChatsOutgoing } from './component';

export const mapStateToProps = (store: IStore) => {
    return {
        userId: store.AdminUser?.userId,
        blockRules: store.AdminUser?.blockRules,
        evolutions: store.AdminUser?.permissions?.evolutions,
        dispatcherSettings: getRawSetting2(store, DISPATCHER_SETTINGS),
        dispatcherLongtermTags: getRawSetting2(store, DISPATCHER_LONGTERM_TAGS),
    };
};

export default withRouter<any, any>(connect<{}, {}, {}>(mapStateToProps)(ChatsOutgoing));
