import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    GET_TASKS = 'GET_TASKS',
    SET_PERFORM = 'SET_PERFORM',
    DROP_PERFORM = 'DROP_PERFORM',
    DROP_PERFORM_NEW = 'DROP_PERFORM_NEW',
    SEND_MESSAGE = 'SEND_MESSAGE',
    GET_COMMENTS = 'GET_COMMENTS',
    LIST = 'LIST',
    TAG_EVOLVE = 'TAG_EVOLVE',
    TAG_DESCRIPTIONS = 'TAG_DESCRIPTIONS',
    ARCHIVE = 'ARCHIVE',
    GET_CAR_INFO = 'GET_CAR_INFO',
    GET_DEFERRED = 'GET_DEFERRED',
    UNDEFER = 'UNDEFER',

    GET_DAMAGES_PHOTOS = 'GET_DAMAGES_PHOTOS',
    GET_SESSION = 'GET_SESSION',

    GET_GLOBAL_SETTINGS = 'GET_GLOBAL_SETTINGS',
    MARK_UP = 'MARK_UP',
    GET_ACTION = 'GET_ACTION',
    GET_TAG_DETAILS = 'GET_TAG_DETAILS',
}

export const requestConfigs: IComponentRequest = {
    [REQUESTS.GET_TASKS]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'chats/feed',
        cgiObj: {
            request_types: 'outgoing',
            performer_id: null,
            tag_names: null,
        },
    },
    [REQUESTS.GET_DEFERRED]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'chats/feed',
        cgiObj: {
            request_types: 'container',
            contained_tag_types: null,
            contained_tag_names: null,
        },
    },
    [REQUESTS.UNDEFER]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'request/undefer',
        cgiObj: {
            tag_id: null,
            chat_id: null,
        },
    },
    [REQUESTS.SET_PERFORM]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'user/tag/perform/start',
    },
    [REQUESTS.DROP_PERFORM]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'user/tag/perform/finish',
    },
    [REQUESTS.DROP_PERFORM_NEW]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'request/defer',
        cgiObj: {
            tag_id: null,
            is_finishing: null,
        },
    },
    [REQUESTS.SEND_MESSAGE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'chat/message',
        cgiObj: {
            user_id: null,
            chat_id: null,
        },
    },
    [REQUESTS.GET_COMMENTS]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'chat/history',
        cgiObj: {
            chat_id: null,
            user_id: null,
        },
    },
    [REQUESTS.LIST]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'chats/list',
    },
    [REQUESTS.TAG_EVOLVE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'tag/evolve',
        cgiObj: {
            tag_id: null,
        },
    },
    [REQUESTS.TAG_DESCRIPTIONS]: {
        api: 'tag/description/list',
    },
    [REQUESTS.ARCHIVE]: {
        api: 'support/requests',
        cgiObj: {
            since: null,
            performer_id: null,
            user_id: null,
            tags: null,
            rev: null,
        },
    },
    [REQUESTS.GET_CAR_INFO]: {
        api: 'car/info',
        cgiObj: {
            car_id: null,
        },
    },
    [REQUESTS.GET_DAMAGES_PHOTOS]: {
        api: 'photo/markup/get',
        cgiObj: {
            session_id: null,
            car_id: null,
            since: null,
            until: null,
            report_dups: true,
        },
    },
    [REQUESTS.GET_SESSION]: {
        api: 'sessions/history',
        cgiObj: {
            numdoc: null,
            session_id: null,
            user_id: null,
        },
    },
    [REQUESTS.GET_GLOBAL_SETTINGS]: {
        api: 'settings/info',
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        cgiObj: {
            prefix: null,
            actuality: null,
        },
    },
    [REQUESTS.MARK_UP]: {
        api: 'photo/metadata/update',
        method: REQUEST_METHOD.POST,
    },
    [REQUESTS.GET_ACTION]: {
        api: 'actions/list',
        cgiObj: {
            action_id: null,
        },
    },
    [REQUESTS.GET_TAG_DETAILS]: {
        api: 'users/tags_history',
        cgiObj: {
            tag_id: null,
            since: null,
            until: null,
        },
    },
};
