import React from 'react';

import { Button, ButtonTypes } from '../../../ui/Button';
import { JsonModal } from '../../../ui/FullModal/JsonModal';
import * as chatsCommonStyle from '../../ChatsCommon/index.css';

interface IChatErrorProps {
    error: any;
    clearError?: () => void;
}

export class ChatError extends React.Component<IChatErrorProps, any> {
    state = {
        showError: false,
    };

    showError(showError) {
        this.setState({ showError });
    }

    render() {
        const errorMessage = this.props?.error?.message;

        return <div className={chatsCommonStyle.error_content}>
            <div>
                <Button colorType={ButtonTypes.warning}
                        className={chatsCommonStyle.error_btn}
                        onClick={this.props?.clearError?.bind(this)}>
                    Скрыть ошибку
                </Button>

                <Button onClick={this.showError.bind(this, true)}
                        className={chatsCommonStyle.error_btn}
                        basic={true}>
                    Показать ошибку
                </Button>
            </div>

            {errorMessage
                ? <div>status: <span>{this.props?.error?.message}</span></div>
                : null
            }

            {this.state.showError
                ? <JsonModal obj={this.props.error} onClose={this.showError.bind(this, false)}/>
                : null
            }
        </div>;
    }
}
