import * as React from 'react';

import { Button } from '../../../ui/Button';
import { Window } from '../../../ui/FullModal';
import TextArea from '../../../ui/TextArea';
import { Request2 } from '../../../utils/request';
import { CHAT_REQUESTS, REQUESTS } from '../request';
import * as style from './index.css';

interface IAddCommentProps {
    originator: string;
    chat_id: string;
    onClose: () => void;
}

export class AddComment extends React.Component<IAddCommentProps> {
    ref: any;
    req;
    state = {
        comment: '',
        isLoading: false,
        error: null,
    };
    request = new Request2({ requestConfigs: CHAT_REQUESTS });

    constructor(props) {
        super(props);
        this.ref = React.createRef();
    }

    onChange(comment) {
        this.setState({ comment });
    }

    componentDidMount(): void {
        this.ref && this.ref.current && this.ref.current.focus();
    }

    componentWillUnmount(): void {
        this.request.abort();
    }

    sendComment() {
        this.setState({ isLoading: true, error: null }, () => {
            this.request.abort();
            this.request.exec(REQUESTS.SEND_MESSAGE, {
                queryParams: {
                    user_id: this.props.originator,
                    chat_id: this.props.chat_id,
                },
                body: {
                    'message': this.state.comment,
                    'traits': ['staff_only'],
                },
            })
                .then(() => {
                    this.setState({
                        isLoading: false,
                    });
                    this.props.onClose();
                })
                .catch(error => {
                    this.setState({
                        isLoading: false,
                        error,
                    });
                });
        });
    }

    render() {
        return <Window onClose={this.props.onClose} title={'Комментарий к топику'} error={this.state.error}>
            <div>
                <h3>Этот коммент только между нами!</h3>
                <div>Пользователь ничего об этом не узнает!!</div>
                <TextArea value={this.state.comment}
                          disabled={this.state.isLoading}
                          onChange={this.onChange.bind(this)}
                          placeholder={'Комментарий'}
                          ref={this.ref}/>
            </div>
            <div className={style.add_comment_controls}>
                <Button disabled={!this.state.comment}
                        onClick={this.sendComment.bind(this)}
                        isLoading={this.state.isLoading}>Отправить</Button>
            </div>
        </Window>;
    }
}
