import React from 'react';

import { Link } from '../../../ui/Link';
import * as style from './index.css';

export const UserCardLinks = React.memo((props: { userId: string; title: string }) => {
    const { userId, title } = props;

    return <div className={style.user_card_links}>
        <h4>{title}</h4>
        <div className={style.wrapper}>
            <Link href={`#/clients/${userId}/info`} target={'_blank'}>КЦ</Link>
            {separator}
            <Link href={`#/clients/${userId}/sessions`} target={'_blank'}>Сессии</Link>
            {separator}
            <Link href={`#/clients/${userId}/bonuses`} target={'_blank'}>Бонусы</Link>
            {separator}
            <Link href={`#/clients/${userId}/billing`} target={'_blank'}>Биллинг</Link>
            {separator}
            <Link href={`#/clients/${userId}/info-old`} target={'_blank'}>Обзор</Link>
        </div>
    </div>;
});

const separator = <span> • </span>;
