import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';

import { getSelectedChatItem } from '../../../reducers/chatReducer/getters';
import { cancelChatCallBack, updateChatItemTag } from '../../../reducers/chatReducer/setters';
import { IStore } from '../../App/store';
import { ChatInfo } from './component';

export interface ChatInfoMapDispatchToProps {
    cancelChatCallBack: () => void;
    updateChatItemTag: (chat, tag) => void;
}

export interface IMapStateToProps {
    evolutions: any[];
    selectedChatItem: any;
    BlockRules: any;
    userId: string;
}

export const mapStateToProps = (store: IStore): IMapStateToProps => {
    return {
        evolutions: store.AdminUser?.permissions?.evolutions,
        selectedChatItem: getSelectedChatItem(store),
        BlockRules: store?.AdminUser?.blockRules,
        userId: store?.AdminUser?.userId ?? '',
    };
};

export function mapDispatchToProps(dispatch: any): ChatInfoMapDispatchToProps {
    return {
        cancelChatCallBack: () => {
            dispatch(cancelChatCallBack());
        },
        updateChatItemTag: (chat, tag) => {
            dispatch(updateChatItemTag(chat, tag));
        },
    };
}

export default withRouter<any, any>(connect<{}, {}, {}>(mapStateToProps, mapDispatchToProps)(ChatInfo));
