import React from 'react';

import * as style from './index.css';

export const ChatToggle = React.memo((props: { isOpen: boolean; toggle: Function }) => {
    return <div className={`${style.toggle} ${props.isOpen ? `${style.is_open}` : ''}`}
                onClick={props.toggle.bind(null)}>
        {
            props.isOpen ? '◄ Свернуть' : '►'
        }
    </div>;
});
