import { connect } from 'react-redux';

import { getSelectedChatItem } from '../../../../reducers/chatReducer/getters';
import { IStore } from '../../../App/store';
import { ChatWindowContent } from './component';

export interface IChatWindowContentMapStateToProps {
    selectedChatItem: any;
}

export const mapStateToProps = (store: IStore): IChatWindowContentMapStateToProps => {
    return {
        selectedChatItem: getSelectedChatItem(store),
    };
};

export default connect<IChatWindowContentMapStateToProps>(mapStateToProps) (ChatWindowContent);
