import { connect } from 'react-redux';

import {
    getOriginatorInfo, getSelectedChatDisplayName,
    getSelectedChatItem,
    getSelectedMenu,
} from '../../../../reducers/chatReducer/getters';
import { updateChatItemTag } from '../../../../reducers/chatReducer/setters';
import { IStore } from '../../../App/store';
import { ChatWindowHeader } from './component';

export interface IChatWindowHeaderMapStateToProps {
    selectedChatItem: any;
    selectedChatDisplayName: string;
    selectedMenu: any;
    originatorInfo: any;
}

export interface IChatWindowHeaderMapDispatchToProps {
    updateChatItemTag?: (chat: any, tag: any) => void;
}

export const mapStateToProps = (store: IStore): IChatWindowHeaderMapStateToProps => {
    return {
        originatorInfo: getOriginatorInfo(store),
        selectedChatItem: getSelectedChatItem(store),
        selectedChatDisplayName: getSelectedChatDisplayName(store),
        selectedMenu: getSelectedMenu(store),
    };
};

export function mapDispatchToProps(dispatch: any): IChatWindowHeaderMapDispatchToProps {
    return {
        updateChatItemTag: (chat, tag) => {
            dispatch(updateChatItemTag(chat, tag));
        },
    };
}

export default connect<IChatWindowHeaderMapStateToProps>(mapStateToProps, mapDispatchToProps)(ChatWindowHeader);
