import { controlType } from '../../../FormConstructor/types';

export const CHAT_TYPES_VARIANTS = ['client_support'];

export const FORWARD_MESSAGES_SCHEMA = {
    user_id: {
        type: controlType.string,
        display_name: 'ID Пользователя',
        order: 0,
    },
    chat_id: {
        type: controlType.string,
        display_name: 'topic link',
        order: 1,
    },
    new_chat_type: {
        type: controlType.variants,
        variants: CHAT_TYPES_VARIANTS,
        display_name: 'chat type',
        order: 2,
        read_only: true,
    },
    comment: {
        type: controlType.text,
        display_name: 'Комментарий',
        order: 3,
    },
    message_ids: {
        type: controlType.variants,
        display_name: 'ID пересылаемых сообщений',
        multi_select: true,
        order: 4,
    },
};
