import React from 'react';

import { CancelButton, SaveButton } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import * as coreStyle from '../../../../ui/index.css';
import { Request2 } from '../../../../utils/request';
import { FormConstructor } from '../../../FormConstructor';
import { CHAT_REQUESTS, REQUESTS } from '../../request';
import { CHAT_TYPES_VARIANTS, FORWARD_MESSAGES_SCHEMA } from './ForwardMessagesSchema';

interface IForwardWindowProps {
    showForwardWindow: (isOpen: boolean) => void;
    user_id: string;
    chat_id: string;
    messages: number[];
    cancelSelect: () => void;
}

interface IForwardWindowState {
    isLoading: boolean;
    error: Error | null;
    formData: object;
}

export default class ForwardWindow extends React.Component<IForwardWindowProps, IForwardWindowState> {
    state: IForwardWindowState = {
        isLoading: false,
        error: null,
        formData: {},
    };
    request = new Request2({ requestConfigs: CHAT_REQUESTS });

    componentWillUnmount() {
        this.request.abort();
    }

    onFormChange(formData) {
        this.setState({ formData });
    }

    onFormSubmit() {
        this.setState({ isLoading: true }, () => {
            const body = this.state.formData;
            this.request.exec(REQUESTS.FORWARD, { body })
                .then(() => {
                    this.setState({ isLoading: false });
                    this.props.cancelSelect();
                    this.props.showForwardWindow(false);
                })
                .catch(error => {
                    this.setState({ error, isLoading: false });
                });
        });
    }

    render() {
        const { showForwardWindow, user_id, chat_id, messages } = this.props;
        const { error, isLoading } = this.state;

        const initialData = {
            user_id,
            chat_id,
            comment: '',
            new_chat_type: CHAT_TYPES_VARIANTS[0],
            message_ids: messages,
        };

        return <Window onClose={showForwardWindow.bind(this, false)}
                       title={'Переслать сообщения'}
                       error={error}>
            <FormConstructor schema={FORWARD_MESSAGES_SCHEMA}
                             initialData={initialData}
                             onChange={this.onFormChange.bind(this)}/>
            <div className={coreStyle.button_container}>
                <CancelButton onClick={showForwardWindow.bind(this, false)}/>
                <SaveButton onClick={this.onFormSubmit.bind(this)} isLoading={isLoading}/>
            </div>
        </Window>;
    }
}
