import { connect } from 'react-redux';

import { IStore } from '../../App/store';
import { NChats } from '../../ChatsCommon/types';
import { ChatWindow } from './component';
import IChatListItem = NChats.IChatListItem;
import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../../constants';
import { getAllUsersArray, getSelectedChatItem } from '../../../reducers/chatReducer/getters';
import { cancelChatCallBack } from '../../../reducers/chatReducer/setters';
import { getRawSetting2 } from '../../../utils/getRawSetting';
import { FAST_ANSWER } from '../../InterfaceAdminConfig/adminConfigKeys';
import { APOLOGIZE_KEY, WAITING_TIME, WELCOME_KEY } from '../constants';

export interface ChatWindowMapDispatchToProps {
    cancelChatCallBack?: () => void;
}

export interface ChatWindowMapStateToProps {
    selectedChatItem?: IChatListItem;
    users: any[];
    settings?: any;
    currentUserId: string;
}

export const mapStateToProps = (store: IStore): ChatWindowMapStateToProps => {
    const welcomes = getRawSetting2(store, `${GVARS_INTERFACE_ADMIN_PREFIX}.${WELCOME_KEY}`);
    const apologizes = getRawSetting2(store, `${GVARS_INTERFACE_ADMIN_PREFIX}.${APOLOGIZE_KEY}`)
        ?.map(el => el.apologize);
    const waitingTime = getRawSetting2(store, `${GVARS_INTERFACE_ADMIN_PREFIX}.${WAITING_TIME}`);
    const fastAnswers = getRawSetting2(store, FAST_ANSWER);
    const settings = { welcomes, apologizes, waitingTime, fastAnswers };
    const currentUserId = store.AdminUser?.userId ?? '';

    return {
        selectedChatItem: getSelectedChatItem(store),
        users: getAllUsersArray(store),
        currentUserId,
        settings,
    };
};

export function mapDispatchToProps(dispatch: any): ChatWindowMapDispatchToProps {
    return {
        cancelChatCallBack: () => {
            dispatch(cancelChatCallBack());
        },
    };
}

export default connect<ChatWindowMapStateToProps, {}, {}>(mapStateToProps, mapDispatchToProps)(ChatWindow);
