import * as React from 'react';

import { Request2 } from '../../../../utils/request';
import { MODEL_ITEMS_COUNT } from '../../constants';
import { Cloud } from '../ClassificationUtils/Cloud';
import { TSetParameters } from '../component';
import { ClassificationDialogContext } from '../context';
import { CLASSIFICATION_REQUESTS, REQUESTS } from '../requests';
import { IClassificationModule } from '../types';

interface IClassificationCloudSuggestProps {
    suggest: boolean;
    setParameters: (dict: TSetParameters) => void;
}

interface IClassificationCloudSuggestState {
    modelClassification: { class: string; confidence: number; id: string }[];
}

export class ClassificationCloudSuggest extends
    React.Component<IClassificationCloudSuggestProps & IClassificationModule, IClassificationCloudSuggestState> {
    state: IClassificationCloudSuggestState = {
        modelClassification: [],
    };
    static contextType = ClassificationDialogContext;
    context!: React.ContextType<typeof ClassificationDialogContext>;
    request = new Request2({ requestConfigs: CLASSIFICATION_REQUESTS });

    componentDidMount() {
        this.getDataByModel();
    }

    getDataByModel() {
        this.context.user_id && this.context.chat_id
            ? this.request.exec(REQUESTS.GET_CLASSIFICATION_BY_MODEL, {
                queryParams: {
                    chat_id: this.context.chat_id,
                    user_id: this.context.user_id,
                },
            })
                .then(response => {
                    this.setState({
                        modelClassification: response?.features
                            ?.sort((a, b) => b.confidence - a.confidence).slice(0, MODEL_ITEMS_COUNT) || [],
                    });
                })
            : null;
    }

    render() {
        const { modelClassification } = this.state;
        const { suggest, setParameters } = this.props;
        const { category } = this.context;

        return <>
            {suggest
                ? <Cloud items={modelClassification}
                         selectedCategory={category}
                         onSelect={(category) => {
                             setParameters({ category });
                         }}/>
                : null
            }
        </>;
    }
}
