import * as React from 'react';

import TextArea from '../../../../ui/TextArea';
import { ClassificationDialogContext } from '../context';
import { IClassificationModule } from '../types';

interface IClassificationCommentProps {
    textareaRef: React.RefObject<TextArea>;
}

interface IClassificationCommentState {

}

export class ClassificationComment extends
    React.Component<IClassificationCommentProps & IClassificationModule, IClassificationCommentState> {
    static contextType = ClassificationDialogContext;
    context!: React.ContextType<typeof ClassificationDialogContext>;

    render() {
        const { textareaRef } = this.props;

        return <TextArea value={this.context.comment}
                         ref={textareaRef}
                         placeholder={'comment'}
                         disabled={this.context.sendingClassification}
                         onChange={(comment) => {
                             this.props.setParameters({ comment });
                         }}/>;
    }
}
