import * as React from 'react';

import TrashIcon from '../../../../../svg-components/trash.component.svg';
import { Button } from '../../../../ui/Button';
import { UserSessionSelect } from '../../../UserSessionSelect/component';
import { CategoryMap } from '../ClassificationUtils/CategoryMap';
import TrackModal from '../ClassificationUtils/TrackModal';
import { ClassificationDialogContext } from '../context';
import style from '../index.css';
import { IClassificationModule } from '../types';

interface IClassificationMetaProps {

}

interface IClassificationMetaState {
    isMapModalOpen: boolean;
    isTrackModalOpen: boolean;
}

export class ClassificationMeta extends
    React.Component<IClassificationMetaProps & IClassificationModule, IClassificationMetaState> {
    state: IClassificationMetaState = {
        isMapModalOpen: false,
        isTrackModalOpen: false,
    };
    static contextType = ClassificationDialogContext;
    context!: React.ContextType<typeof ClassificationDialogContext>;

    triggerMapModal(value) {
        this.setState({
            isMapModalOpen: value,
        });
    }

    triggerTrackModal(isTrackModalOpen) {
        this.setState({
            isTrackModalOpen,
        });
    }

    render() {
        const { isMapModalOpen, isTrackModalOpen } = this.state;

        return <>
            {isMapModalOpen
                ? <CategoryMap openMap={this.triggerMapModal.bind(this)}
                               confirmAddress={(value: { lat: number; lon: number }) => {
                                   this.props.setParameters({ coordinates: value });
                               }}/>
                : null
            }

            {isTrackModalOpen
                ? <TrackModal onClose={this.triggerTrackModal.bind(this, false)}
                              sessionId={this.context.session_id || ''}
                              setViolation={(value: [number, number][]) => {
                                  this.props.setParameters({ violation: value });
                              }}
                              setScoring={(value: [number, number][]) => {
                                  this.props.setParameters({ scoring: value });
                              }}/>
                : null
            }

            <div className={style.session_select}>
                {this.context.user_id
                    ? <UserSessionSelect user_id={this.context.user_id}
                                         onSelect={(value) => {
                                             this.props.setParameters({ session_id: value });
                                         }}/>
                    : null
                }
            </div>

            {this.context.coordinates
                ? <div className={style.info_block}>
                    Координаты: {this.context.coordinates.lat}, {this.context.coordinates.lon}
                    <TrashIcon className={style.trash_button}
                               onClick={() => {
                                   this.props.setParameters({ coordinates: null });
                               }}/>
                </div>
                : null
            }

            <Button className={style.mapButtons}
                    disabled={!this.context.category}
                    onClick={this.triggerMapModal.bind(this, true)}
                    basic>
                {this.context.coordinates ? 'Изменить' : 'Указать'} местоположение
            </Button>

            {this.context.scoring.length
                ? <div>
                    <div>Резкости:</div>

                    {this.context.scoring.map(el => {
                        return <div key={el[0]}>{el[0]}, {el[1]}</div>;
                    })}
                </div>
                : null
            }

            {this.context.violation.length
                ? <div>
                    <div>Превышения:</div>

                    {this.context.violation.map(el => {
                        return <div key={el[0]}>{el[0]}, {el[1]}</div>;
                    })}
                </div>
                : null
            }

            <Button className={style.mapButtons}
                    disabled={!(this.context.category && this.context.session_id)}
                    onClick={this.triggerTrackModal.bind(this, true)}
                    basic={true}>
                Отметить резкость или превышение
            </Button>
        </>;
    }
}
