import * as React from 'react';

import { Collapse2 } from '../../../../ui/Collapse2';
import { Window } from '../../../../ui/FullModal';
import { Link } from '../../../../ui/Link';
import Select from '../../../../ui/Select';
import { SimpleError } from '../../../SimpleError';
import { ITaskSenderExport, TaskSender } from '../ClassificationUtils/TaskSender';
import { ClassificationDialogContext } from '../context';
import style from '../index.css';
import { IClassificationModule, TStData } from '../types';
import { IClassificationSTMapStateToProps } from './index';

interface IClassificationSTProps extends ITaskSenderExport, IClassificationSTMapStateToProps {
    shouldSendComment: boolean;
}

interface IClassificationSTState {
    stData: TStData;
    stError: Error | null;
}

@TaskSender()
export class ClassificationST extends
    React.Component<IClassificationSTProps & IClassificationModule, IClassificationSTState> {
    state: IClassificationSTState = {
        stData: null,
        stError: null,
    };
    static contextType = ClassificationDialogContext;
    context!: React.ContextType<typeof ClassificationDialogContext>;

    getSTOptions() {
        return this.context.stData?.additional_data?.st_links?.map(st => {
            return {
                value: st.link,
                text: st.hint,
            };
        }) ?? [];
    }

    sendCommentToST() {
        if (this.context.selectedST) {
            this.props.sendComment?.({
                task_id: this.context.selectedST,
                tag_id: this.context.tag_id ?? '',
                chat_id: this.context.chat_id ?? '',
                user_id: this.context.user_id,
                session_id: this.context.session_id,
                comment: this.context.comment,
                setError: this.setSTError.bind(this),
            }, () => {
                this.props.setParameters({
                    sentSTMessage: true,
                    sendingSTMessage: false,
                });
            });
        }
    }

    setSTError(stError: Error) {
        this.setState({ stError });
    }

    repeatSt() {
        this.setState({
            stError: null,
        }, () => {
            this.sendCommentToST();
        });
    }

    componentDidUpdate(prevProps: IClassificationSTProps) {
        if (this.props.shouldSendComment !== prevProps.shouldSendComment
            && this.props.shouldSendComment
        ) {
            this.sendCommentToST();
        }
    }

    render() {
        const { stError } = this.state;
        const stOptions = this.getSTOptions();
        const showST = this.props.BlockRules.ShowTrackerTasks;

        return <>
            {showST && stOptions.length
                ? <div className={style.st_wrapper}>
                    <Select options={stOptions}
                            className={style.st_select}
                            placeholder={'Возможные таски'}
                            onSelect={(value) => {
                                this.props.setParameters({ selectedST: value as unknown as string });
                            }}/>
                </div>
                : null
            }
            {stError && this.context.selectedST
                ? <Window onClose={this.setSTError.bind(this, null)}
                          className={style.st_error}>
                    <div className={style.error_desc}>Не удалось отправить комментарий в Трекер :(</div>
                    <Collapse2 title={'Ошибка'} children={<SimpleError error={stError}/>}/>
                    <div className={style.error_desc}>Вы можете
                        <Link onClick={this.repeatSt.bind(this)}> повторить</Link>
                    </div>
                    <div className={style.error_desc}>
                        Или <Link href={this.context.selectedST} target={'_blank'}> оставить комментарий</Link> самостоятельно
                    </div>
                </Window>
                : null
            }
        </>;
    }
}
