import React, { useEffect, useState } from 'react';

import { Button } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import { initMap } from '../../../MainMap/utils';
import { CATEGORY_MAP_ID } from '../../constants';
import style from '../index.css';

interface ICategoryMapProps {
    openMap: (isMapOpen: boolean) => void;
    confirmAddress: (coordinates: object) => void;
}

declare let ymaps: any;

export const CategoryMap = ((props: ICategoryMapProps) => {
    const [coordinates, setCoordinates] = useState<any>(null);
    let CATEGORY_MAP;

    const addSearchControl = (map) => {
        const SEARCH_CONTROL = new ymaps.control.SearchControl();

        SEARCH_CONTROL?.events?.add?.('resultselect', () => {
            const selectedIndex = SEARCH_CONTROL.getSelectedIndex() || 0;
            const selectedItem = SEARCH_CONTROL.getResultsArray()?.[selectedIndex];
            const coord = selectedItem?.geometry?.getCoordinates();

            setCoordinates({ lon: coord[0], lat: coord[1] });
        });

        map.controls.add(SEARCH_CONTROL);
    };

    useEffect(() => {
        initMap(CATEGORY_MAP_ID, (map) => {
            CATEGORY_MAP = map;
            addSearchControl(CATEGORY_MAP);
        });
    }, []);

    const onConfirmButtonClick = () => {
        props.openMap(false);
        props.confirmAddress(coordinates);
    };

    return <Window onClose={props.openMap.bind(null, false)} title={'Определение адреса'}>
        <div className={style.info_block}>
            {coordinates
                ? <div>
                    <span className={style.text}>
                        Выбранные координаты: {coordinates.lat}, {coordinates.lon}
                    </span>

                    <Button onClick={onConfirmButtonClick}>Подтвердить</Button>
                </div>
                : <div>Выберите адрес</div>
            }
        </div>

        <div id={CATEGORY_MAP_ID} className={style.map_container}/>
    </Window>;
});
