import React, { useEffect, useState } from 'react';

import { ONE_SECOND } from '../../../../constants';
import FormatDate from '../../../../ui/FormatDate';
import { Link } from '../../../../ui/Link';
import styleTable from '../../../../ui/Table/index.css';
import { NChats } from '../../../ChatsCommon/types';
import style from '../index.css';
import ICategory = NChats.ICategory;
import { Confirm } from '../../../../ui/FullModal';
import { JsonModal } from '../../../../ui/FullModal/JsonModal';
import { Request2 } from '../../../../utils/request';
import { CLASSIFICATION_REQUESTS,REQUESTS } from '../requests';

interface IClassificationListProps {
    classificationData: ICategory[];
    tag_id: any;
    onClassified: () => void;
}

export const ClassificationList = (props: IClassificationListProps) => {
    const request = new Request2({ requestConfigs: CLASSIFICATION_REQUESTS });
    const [metaData, setMetaData]: any = useState(null);
    const [deleteItem, setDeleteItem]: any = useState(null);
    const [deleteError, setDeleteError]: any = useState(null);

    function deleteChosenItem() {
        props.tag_id && request.exec(REQUESTS.REMOVE_CLASSIFICATION, {
            queryParams: {
                tag_id: props.tag_id,
                id: deleteItem?.id ?? '',
            },
        })
            .then(() => {
                props.onClassified();
            })
            .catch(error => {
                setDeleteError(error);
            });
    }

    useEffect(() => {
        return () => {
            request.abort();
        };
    });

    return <>
        <table className={styleTable.table}>
            <thead>
                <tr>
                    <th>#</th>
                    <th>cat/comment</th>
                    <th/>
                    <th>date</th>
                    <th colSpan={2}/>
                </tr>
            </thead>
            <tbody>
                {props.classificationData.map((item: ICategory, index) => {
                    const meta_info = item.meta_info;
                    const link = `/#/clients/${item.operator_id}/request_aggregator`;

                    return <tr key={index}>
                        <td>{index + 1}</td>
                        <td>
                            <div> {item.category?.meta?.label}</div>
                            <div><i>{item.comment}</i></div>
                        </td>
                        <td>
                            <Link target={'_blank'} href={link}>оператор</Link>
                            <div className={style.meta_info}>
                                {meta_info && Object.keys(meta_info).length
                                    ? <Link onClick={setMetaData.bind(null, item)}>
                                    meta_info
                                    </Link>
                                    : null
                                }
                            </div>
                        </td>
                        <td><FormatDate value={item.timestamp * ONE_SECOND}/></td>
                        <td colSpan={2}>
                            <Link onClick={setDeleteItem.bind(null, item)}>del</Link>
                        </td>
                    </tr>;
                })
                }
            </tbody>
        </table>

        {deleteItem
            ? <Confirm error={deleteError}
                       onClose={setDeleteItem.bind(null, null)}
                       accept={deleteChosenItem.bind(null)}
                       question={'Удалить выбранную классификацию?'}/>
            : null
        }

        {metaData
            ? <JsonModal obj={metaData?.meta_info ?? {}} onClose={setMetaData.bind(null, null)}/>
            : null
        }
    </>;
};
