import React from 'react';

import { ONE_SECOND } from '../../../../constants';
import FormatDate from '../../../../ui/FormatDate';
import { Link } from '../../../../ui/Link';
import * as styleTable from '../../../../ui/Table/index.css';
import { Request2 } from '../../../../utils/request';
import { SimpleError } from '../../../SimpleError';
import Spin from '../../../Spin';
import * as style from '../index.css';
import { CLASSIFICATION_REQUESTS, REQUESTS } from '../requests';

export class History extends React.Component<any, any> {
    request = new Request2({ requestConfigs: CLASSIFICATION_REQUESTS });
    state: any = {
        historyIsLoading: false,
        history: null,
        error: null,
    };

    getHistory() {
        this.props.tag_id && this.setState(() => ({
            historyIsLoading: true,
        }), () => {
            this.request.exec(REQUESTS.GET_CLASSIFICATION_HISTORY,
                { queryParams: { tag_id: this.props.tag_id } },
            )
                .then(response => {
                    this.setState(() => ({
                        history: response,
                        historyIsLoading: false,
                    }));
                })
                .catch(error => {
                    this.setState(() => ({
                        error,
                        historyIsLoading: false,
                    }));
                });
        });
    }

    componentDidMount(): void {
        this.getHistory();
    }

    componentWillUnmount() {
        this.request.abort();
    }

    render() {
        return <div className={`${style.section} ${style.right}`}>
            {
                this.state.historyIsLoading
                    ? <Spin/>
                    : this.state.error
                        ? <SimpleError error={this.state.error}/>
                        : <>
                            <strong>История</strong>
                            <table className={styleTable.table}>
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>action</th>
                                        <th>cat/comment</th>
                                        <th>id</th>
                                        <th>date</th>
                                        <th/>
                                    </tr>
                                </thead>
                                <tbody>
                                    {
                                        this.state.history?.items?.map((item, index) => {
                                            return <tr key={index}>
                                                <td>{index + 1}</td>
                                                <td>{item.action}</td>

                                                <td>
                                                    <div> {item.category?.meta?.label}</div>
                                                    <div><i>{item.comment}</i></div>
                                                </td>
                                                <td>{item.id}</td>
                                                <td><FormatDate value={item.timestamp * ONE_SECOND}/></td>
                                                <td><Link href={`/#/clients/${item.operator_id}/info`}>user</Link>
                                                </td>
                                            </tr>;
                                        })
                                    }
                                </tbody>
                            </table>
                        </>
            }
        </div>;
    }
}
