import React from 'react';
import { withRouter } from 'react-router-dom';

import TrashIcon from '../../../../../svg-components/trash.component.svg';
import { Button } from '../../../../ui/Button';
import { Window } from '../../../../ui/FullModal';
import { chunksErrorHandling } from '../../../../utils/chunksErrorHandling';
import style from '../index.css';

const TrackMap = React.lazy(() => chunksErrorHandling(() => import('../../../TrackMap')));

interface ITrackModalProps {
    onClose: () => void;
    setScoring: (scoringItems) => void;
    setViolation: (violationItems) => void;
    sessionId: string;
    location?: any;
}

interface ITrackModalState {
    scoringItems: [number, number][];
    violationItems: [number, number][];
}

class TrackModal extends React.Component<ITrackModalProps, ITrackModalState> {
    state: ITrackModalState = {
        scoringItems: [],
        violationItems: [],
    };

    setScoring(newScoring) {
        if (!this.state.scoringItems.some(el => {
            return el[0] === newScoring[0] && el[1] === newScoring[1];
        })) {
            this.setState({
                scoringItems: [
                    ...this.state.scoringItems,
                    newScoring,
                ],
            });
        }
    }

    setViolation(newViolation) {
        if (!this.state.violationItems.some(el => {
            return el[0] === newViolation[0] && el[1] === newViolation[1];
        })) {
            this.setState({
                violationItems: [
                    ...this.state.violationItems,
                    newViolation,
                ],
            });
        }
    }

    removeScoring(item) {
        const ind = this.state.scoringItems.findIndex(el => {
            return el[0] === item[0] && el[1] === item[1];
        });

        const scoringItems = this.state.scoringItems.slice();
        scoringItems.splice(ind, 1);

        this.setState({ scoringItems });
    }

    removeViolation(item) {
        const ind = this.state.violationItems.findIndex(el => {
            return el[0] === item[0] && el[1] === item[1];
        });

        const violationItems = this.state.violationItems.slice();
        violationItems.splice(ind, 1);

        this.setState({ violationItems });
    }

    onScoringSave() {
        this.props.setScoring(this.state.scoringItems);
        this.props.setViolation(this.state.violationItems);
        this.props.onClose();
    }

    render() {
        const { onClose, sessionId, location } = this.props;

        return <Window onClose={onClose.bind(this)}>
            <div className={style.scoring_meta}>
                {this.state.scoringItems.length
                    ? <div>
                        <div>
                            <b>Выбранные резкости:</b>
                        </div>
                        <div>
                            {this.state.scoringItems.map(el => {
                                return <div key={el[0]} className={style.coord_items}>
                                    {el[0]}, {el[1]}

                                    <TrashIcon onClick={this.removeScoring.bind(this, el)}
                                               className={style.trash_button}/>
                                </div>;
                            })}
                        </div>
                    </div>
                    : null
                }

                {this.state.violationItems.length
                    ? <div>
                        <div>
                            <b>Выбранные превышения:</b>
                        </div>
                        <div>
                            {this.state.violationItems.map(el => {
                                return <div key={el[0]} className={style.coord_items}>
                                    {el[0]}, {el[1]}

                                    <TrashIcon onClick={this.removeViolation.bind(this, el)}
                                               className={style.trash_button}/>
                                </div>;
                            })}
                        </div>
                    </div>
                    : null
                }

                {this.state.scoringItems.length || this.state.violationItems.length
                    ? <div>
                        <Button onClick={this.onScoringSave.bind(this)}>
                            Сохранить
                        </Button>
                    </div>
                    : null
                }
            </div>

            <div className={style.track}>
                <TrackMap sessionId={sessionId}
                          isScoringClassification={true}
                          location={location}
                          setScoring={this.setScoring.bind(this)}
                          setViolation={this.setViolation.bind(this)}/>
            </div>
        </Window>;
    }
}

export default withRouter<any, any>((TrackModal));
