import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../../utils/request';

export enum REQUESTS {
    GET_CLASSIFICATION_TREE = 'GET_CLASSIFICATION_TREE',
    GET_CLASSIFICATION_BY_MODEL = 'GET_CLASSIFICATION_BY_MODEL',
    GET_CLASSIFICATION_HISTORY = 'GET_CLASSIFICATION_HISTORY',

    SET_CLASSIFICATION = 'SET_CLASSIFICATION',

    REMOVE_CLASSIFICATION = 'REMOVE_CLASSIFICATION',

    //ST
    ADD_COMMENT = 'ADD_COMMENT',

    GET_USER_INFO = 'GET_USER_INFO',
    GET_TAG_DETAILS = 'GET_TAG_DETAILS',
}

export const CLASSIFICATION_REQUESTS: IComponentRequest = {

    [REQUESTS.GET_CLASSIFICATION_TREE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'categorization/tree',
    },

    [REQUESTS.GET_CLASSIFICATION_BY_MODEL]: {
        api: 'chat/classify',
        cgiObj: {
            chat_id: null,
            user_id: null,
        },
    },

    [REQUESTS.SET_CLASSIFICATION]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'categorization/add',
    },

    [REQUESTS.REMOVE_CLASSIFICATION]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'categorization/remove',
        cgiObj: {
            tag_id: null,
            id: null,
        },
    },

    [REQUESTS.GET_CLASSIFICATION_HISTORY]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'categorization/history',
        cgiObj: {
            tag_id: null,
        },
    },

    [REQUESTS.REMOVE_CLASSIFICATION]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'categorization/remove',
        cgiObj: {
            tag_id: null,
            id: null,
        },
    },

    [REQUESTS.ADD_COMMENT]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.ST_API,
        api: 'issues/${task_id}/comments',
    },

    [REQUESTS.GET_USER_INFO]: {
        api: 'user/report',
        cgiObj: {
            user_id: null,
        },
    },

    [REQUESTS.GET_TAG_DETAILS]: {
        api: 'users/tags_history',
        cgiObj: {
            tag_id: null,
            since: null,
        },
    },

};
