import { IClassificationMetaItem, ITreeOptionAdditional } from './TreeSuggest';

export type TStData = { additional_data: ITreeOptionAdditional } | null;

export interface IClassificationQueryBody {
    tag_id: string;
    comment: string;
    category: string;
    meta_info: {
        // Даже если сессия не прнивязана, мы должны указать в чатах, что обращение не касается сессии и посылаем ноль
        session_id: string | 0 | undefined;
        coordinates?: {lat: number; lon: number};
        st?: IClassificationMetaItem;
        scoring?: [number, number][];
        violation?: [number, number][];
    };
}

export interface IClassificationDialogParameters {
    session_id: string | undefined | 0;
    coordinates: {lat: number; lon: number} | null;
    scoring: [number, number][];
    violation: [number, number][];
    category: string | null;
    comment: string;
    stData: TStData;
    selectedST: string | null;
    sentClassification: boolean;
    sendingClassification: boolean;
    sendingSTMessage: boolean;
    sentSTMessage: boolean;
    user_id: string | null;
    tag_id: string | null;
    chat_id: string | null;
    addAnotherClassification: boolean;
    sendingClassificationError: Error | null;
    isClassificationTreeOpened: boolean;
}

export interface IClassificationModule {
    setParameters: (params: Partial<IClassificationDialogParameters>) => void;
}

export type TObjectOfInterfaceKeys<T> = { [P in keyof T]: P; }
export const ClassificationDialogParametersKeys: TObjectOfInterfaceKeys<IClassificationDialogParameters> = {
    user_id: 'user_id',
    session_id: 'session_id',
    coordinates: 'coordinates',
    scoring: 'scoring',
    violation: 'violation',
    category: 'category',
    comment: 'comment',
    stData: 'stData',
    selectedST: 'selectedST',
    sendingClassification: 'sendingClassification',
    sentClassification: 'sentClassification',
    sendingSTMessage:'sendingSTMessage',
    sentSTMessage: 'sentSTMessage',
    tag_id: 'tag_id',
    chat_id: 'chat_id',
    addAnotherClassification: 'addAnotherClassification',
    sendingClassificationError: 'sendingClassificationError',
    isClassificationTreeOpened: 'isClassificationTreeOpened',
};
