import { connect } from 'react-redux';

import { getFeedData, getIsFeedLoading, getMenuUsers, getSelectedMenu } from '../../../reducers/chatReducer/getters';
import { selectChatItem, setSelectList } from '../../../reducers/chatReducer/setters';
import { getRawSetting } from '../../../utils/getRawSetting';
import { IStore } from '../../App/store';
import { Feed } from './component';

const COUNT_TO_PERFORM_CHATS = 'interface_admin.count_to_perform_chats';

export interface FeedStateToProps {
    feedData: any[];
    users: {};
    isLoading: boolean;
    countToPerformChats: number;
    selectedMenu: any;
    blockRules: Record<string, boolean>;
    whoAmI: string;
}

export const mapStateToProps = (store: IStore): FeedStateToProps => {
    const countToPerformChats = Math.round(+getRawSetting(store, COUNT_TO_PERFORM_CHATS)) || 1;
    const blockRules = store.AdminUser?.blockRules ?? {};
    const selectedMenu = getSelectedMenu(store);
    const isLoading = getIsFeedLoading(store);
    const feedData = getFeedData(store);
    const users = getMenuUsers(store);
    const whoAmI = store.AdminUser?.userId ?? '';

    return {
        countToPerformChats,
        selectedMenu,
        blockRules,
        isLoading,
        feedData,
        whoAmI,
        users,
    };
};

export function mapDispatchToProps(dispatch: any): any {
    return {
        selectChatItem: (item) => {
            dispatch(selectChatItem(item));
        },
        setSelectList: (type, menu, chat) => {
            dispatch(setSelectList(type, menu, chat));
        },
    };
}

export default connect<FeedStateToProps, {}, {}>(mapStateToProps, mapDispatchToProps)(Feed);
