import { connect } from 'react-redux';
import { withRouter } from 'react-router-dom';

import { getLinesListData, getSelectedMenu, getSelectedMenuItem } from '../../../reducers/chatReducer/getters';
import { cancelChatCallBack, setChats, setFeedIsLoading, setSelectList } from '../../../reducers/chatReducer/setters';
import { IStore } from '../../App/store';
import { LinesListComponent } from './component';

export const mapStateToProps = (store: IStore): any => {
    const selectedMenu = getSelectedMenu(store);
    const selectedMenuItem = getSelectedMenuItem(store);
    const linesListData = getLinesListData(store);

    return {
        selectedMenu,
        selectedMenuItem,
        linesListData,
        Lang: store.Lang,
    };
};

export interface LinesListDispatchToProps {
    setSelectList: (type, menu) => void;
    setChats: (chats, error) => void;
    setFeedIsLoading: (state: boolean) => void;
}

export function mapDispatchToProps(dispatch: any): LinesListDispatchToProps {
    return {
        setSelectList: (type, menu) => {
            dispatch(setSelectList(type, menu));
        },
        setChats: (chats, error) => {
            dispatch(setChats(chats, error));
        },
        setFeedIsLoading: (state) => {
            dispatch(setFeedIsLoading(state));
            dispatch(cancelChatCallBack());
        },
    };
}

export default withRouter<any, any>(
    connect<IStore, LinesListDispatchToProps, {}>(mapStateToProps, mapDispatchToProps)(LinesListComponent),
);
