import * as React from 'react';

import { Window } from '../../../../ui/FullModal';
import { Tabs } from '../../../../ui/Tabs';
import { Request2 } from '../../../../utils/request';
import { IDialogProps } from '../../../ChatsCommon/TopicView/component';
import Spin from '../../../Spin';
import { CHAT_REQUESTS, REQUESTS } from '../../request';
import { IStickersArray, StickerDialogTabs } from '../../types';
import * as style from '../index.css';
import StickerView from '../StickerView';

interface IDialogState {
    currentTab: StickerDialogTabs;
    isLoading: boolean;
    error: Error | null;
    stickers: IStickersArray[];
}

export default class StickerDialog extends React.Component<IDialogProps, IDialogState> {
    tabs = [{ name: 'Stickers', link: StickerDialogTabs.STICKERS }];
    request = new Request2({ requestConfigs: CHAT_REQUESTS });
    state = {
        currentTab: StickerDialogTabs.STICKERS,
        isLoading: false,
        error: null,
        stickers: [] as IStickersArray[],
    };

    selectTab(currentTab) {
        this.setState({
            currentTab,
        }, () => {
            if (this.state.currentTab === StickerDialogTabs.STICKERS) {
                this.loadStickers();
            }
        });
    }

    componentDidMount(): void {
        this.loadStickers();
    }

    loadStickers() {
        this.setState({
            isLoading: true,
        }, async () => {
            const response = await this.request.exec(REQUESTS.GET_STICKERS);
            this.setState({
                stickers: response.stickers || [] as IStickersArray[],
                isLoading: false,
            });
        });
    }

    selectSticker(url) {
        this.props.sendMessage && this.props.sendMessage(url);
        this.props.onClose();
    }

    render() {
        const stickers = this.state.stickers
            .filter(sticker => sticker.is_active) || [];

        return <Window onClose={this.props.onClose.bind(this)}
                       error={this.state.error}>
            <Tabs currentTab={this.state.currentTab} tabs={this.tabs} selectTab={this.selectTab.bind(this)}/>
            {
                this.state.isLoading ? <Spin/>
                    : <div className={style.stickers_content}>
                        {
                            stickers.length &&
                            stickers.map((sticker: IStickersArray) => {
                                return <StickerView url={sticker.url}
                                                    key={sticker.id}
                                                    onClick={this.selectSticker.bind(this, sticker.url)}/>;
                            })
                            || <div>стикеры не загружены</div>
                        }
                    </div>
            }
        </Window>;
    }
}
