import Lottie from 'lottie-web';
import * as React from 'react';

import * as style from '../index.css';

export default class StickerView extends React.Component<{ url: string; onClick?: (url) => void }> {
    ref: any;

    constructor(props) {
        super(props);
        this.ref = React.createRef();
    }

    shouldComponentUpdate(nextProps, nextState): boolean {
        return this.props.url !== nextProps.url;
    }

    componentDidMount(): void {
        if (this.props.url.includes('.json')) {
            Lottie.loadAnimation({
                container: this.ref.current,
                renderer: 'svg',
                loop: true,
                autoplay: true,
                path: this.props.url,
            });
        }
    }

    render() {
        return this.props.url.includes('.webp')
            && <img src={this.props.url}
                    className={style.sticker_item}
                    onClick={this.props.onClick && this.props.onClick.bind(this)}/>
            || <div ref={this.ref}
                    className={style.sticker_item}
                    onClick={this.props.onClick && this.props.onClick.bind(this)}>
            </div>;
    }
}
