import React from 'react';

import { ChatHistoryItemType } from './types';

export const ARCHIVE_USER_SUPPORT_CHAT_TAG = '@user_support_chat_tag';
export const ACTION_HISTORY_TITLE = 'История действий с чатом';
export const APOLOGIZE_KEY = 'chat_apologizes_list';
export const WELCOME_KEY = 'chat_welcomes_list';
export const WAITING_TIME = 'waiting_time';
export const CATEGORY_MAP_ID = 'category_map';
export const PDF_TYPE = 'application/pdf';
export const DEFERRED_MARK = 'deferred';

export const VALIDATION_CONFIRM_QUESTION = <>
    Возможно, в тексте есть <b>полный</b> номер телефона. Все равно отправить сообщение?
</>;

export const NO_REGION_CAR_NUMBER = 6;
export const MODEL_ITEMS_COUNT = 5;
export const COUNT_FIRST = 1;

export const ChatHistoryItemTypeDescription = {
    [ChatHistoryItemType.COMMON_MESSAGE]: 'Сообщение из чата',
    [ChatHistoryItemType.MEDIA_RESOURCES]: 'фото/видео',
    [ChatHistoryItemType.CREATED_CHAT]: 'Создание чата',
    [ChatHistoryItemType.CLOSED_CHAT]: 'Чат закрыт',
    [ChatHistoryItemType.NOTE]: 'Заметка',
    [ChatHistoryItemType.SEPARATOR]: 'Служебный разделитель',
    [ChatHistoryItemType.BONUS]: 'Бонус',
    [ChatHistoryItemType.DEEP_HISTORY]: 'Из истории',
    [ChatHistoryItemType.CLASSIFY]: 'Классификация',
};

export const StickerView = React.lazy(() => import('./Sticker/StickerView'));
export const PDF_ICON = 'https://carsharing.s3.yandex.net/drive/static/registration-icons/link.png';
