import { connect } from 'react-redux';

import {
    cancelChatCallBack,
    selectChatItem,
    setChats,
    setFeedIsLoading,
    setSelectList,
} from '../../reducers/chatReducer/setters';
import { IStore } from '../App/store';
import { Chats } from './component';

export interface ChatsDispatchToProps {
    setSelectList: (type, menu) => void;
    setChats: (chats, error) => void;
    setFeedIsLoading: (state: boolean) => void;
    selectChatItem: (item) => void;
}

export const mapStateToProps = (store: IStore): IStore => {
    return {
        Lang: store.Lang,
    };
};

export function mapDispatchToProps(dispatch: any): ChatsDispatchToProps {
    return {
        setChats: (chats, error) => {
            dispatch(setChats(chats, error));
        },
        setSelectList: (type, menu) => {
            dispatch(setSelectList(type, menu));
        },
        setFeedIsLoading: (state) => {
            dispatch(setFeedIsLoading(state));
            dispatch(cancelChatCallBack());
        },
        selectChatItem: (item) => {
            dispatch(selectChatItem(item));
        },
    };
}

export default connect<IStore, ChatsDispatchToProps, {}>(mapStateToProps, mapDispatchToProps)(Chats);
