import { API_PREFIXES, IComponentRequest, REQUEST_METHOD } from '../../utils/request';

export enum REQUESTS {
    FEED = 'FEED',
    HISTORY = 'HISTORY',
    UPDATE_USER_TAG = 'UPDATE_USER_TAG',
    SET_PERFORM = 'SET_PERFORM',
    DROP_PERFORM = 'DROP_PERFORM',
    DROP_PERFORM_NEW = 'DROP_PERFORM_NEW',
    TAG_DESCRIPTIONS = 'TAG_DESCRIPTIONS',
    SEND_MESSAGE = 'SEND_MESSAGE',
    EDIT_MESSAGE = 'EDIT_MESSAGE',
    SESSION_HISTORY = 'SESSION_HISTORY',
    REGISTER_RESOURCE = 'REGISTER_RESOURCE',
    UPLOAD_RESOURCE = 'UPLOAD_RESOURCE',
    LIST = 'LIST',
    GET_LIST = 'GET_LIST',
    ARCHIVE = 'ARCHIVE',

    //classification
    GET_CLASSIFICATION_TREE = 'GET_CLASSIFICATION_TREE',
    GET_CLASSIFICATION_HISTORY = 'GET_CLASSIFICATION_HISTORY',
    REMOVE_CLASSIFICATION = 'REMOVE_CLASSIFICATION',
    SET_CLASSIFICATION = 'SET_CLASSIFICATION',

    GET_CLASSIFICATION_BY_MODEL = 'GET_CLASSIFICATION_BY_MODEL',
    GET_USER_TAGS_HISTORY = 'GET_USER_TAGS_HISTORY',

    GET_STICKERS = 'GET_STICKERS',

    UNDEFER = 'UNDEFER',

    FORWARD = 'FORWARD',
    GET_NOTIFIERS = 'GET_NOTIFIERS',
    JUMP_TO_NODE = 'JUMP_TO_NODE',
}

export const CHAT_REQUESTS: IComponentRequest = {
    [REQUESTS.LIST]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'chats/list',
    },

    [REQUESTS.GET_LIST]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'chats/list',
        cgiObj: {
            user_id: null,
        },
    },

    [REQUESTS.FEED]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'chats/feed',
        cgiObj: {
            performer_id: null,
            tag_names: null,
            chat_id: null,
            user_id: null,
            limit: null,
            request_types: null,
        },
    },
    [REQUESTS.HISTORY]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'chat/history',
        cgiObj: {
            chat_id: null,
            user_id: null,
        },
    },
    [REQUESTS.UPDATE_USER_TAG]: {
        method: REQUEST_METHOD.POST,
        api: 'user_tags/update',
        cgiObj: {
            tag_id: null,
        },
    },
    [REQUESTS.SET_PERFORM]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'user/tag/perform/start',
    },
    [REQUESTS.DROP_PERFORM]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'user/tag/perform/finish',
    },

    [REQUESTS.DROP_PERFORM_NEW]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'request/defer',
        cgiObj: {
            tag_id: null,
            is_finishing: null,
            ignore_external: null,
        },
    },

    [REQUESTS.TAG_DESCRIPTIONS]: {
        api: 'tag/description/list',
    },

    [REQUESTS.SEND_MESSAGE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'chat/message',
        cgiObj: {
            user_id: null,
            chat_id: null,
        },
    },

    [REQUESTS.EDIT_MESSAGE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'chat/message/edit',
    },

    [REQUESTS.SESSION_HISTORY]: {
        api: 'sessions/history',
        cgiObj: {
            numdoc: null,
            ts_since: null,
            user_id: null,
            car_id: null,
            session_id: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.REGISTER_RESOURCE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'chat/message',
        cgiObj: {
            chat_id: null,
            user_id: null,
        },
    },
    [REQUESTS.UPLOAD_RESOURCE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'chat/resource',
        cgiObj: {
            chat_id: null,
            resource_id: null,
            user_id: null,
        },
    },

    [REQUESTS.ARCHIVE]: {
        api: 'support/requests',
        cgiObj: {
            since: null,
            performer_id: null,
            user_id: null,
            tags: null,
            rev: null,
        },
    },

    [REQUESTS.GET_CLASSIFICATION_BY_MODEL]: {
        api: 'chat/classify',
        cgiObj: {
            chat_id: null,
            user_id: null,
        },
    },

    [REQUESTS.GET_CLASSIFICATION_HISTORY]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'categorization/history',
        cgiObj: {
            tag_id: null,
        },
    },

    [REQUESTS.REMOVE_CLASSIFICATION]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'categorization/remove',
        cgiObj: {
            tag_id: null,
            id: null,
        },
    },

    [REQUESTS.GET_CLASSIFICATION_TREE]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'categorization/tree',
    },

    [REQUESTS.SET_CLASSIFICATION]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'categorization/add',
    },
    [REQUESTS.GET_USER_TAGS_HISTORY]: {
        api: 'users/tags_history',
        cgiObj: {
            object_id: null,
            duration: null,
            since: null,
            until: null,
        },
    },
    [REQUESTS.GET_STICKERS]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'chat/stickers/list',
    },
    [REQUESTS.UNDEFER]: {
        method: REQUEST_METHOD.POST,
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        api: 'request/undefer',
        cgiObj: {
            tag_id: null,
            chat_id: null,
        },
    },
    [REQUESTS.FORWARD]: {
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
        api: 'taxi_chat/forward',
    },
    [REQUESTS.GET_NOTIFIERS]: {
        api: 'notifiers/info',
        cgiObj: {
            ids: null,
        },
    },
    [REQUESTS.JUMP_TO_NODE]: {
        api: 'chat/node_jump',
        apiPrefix: API_PREFIXES.SUPPORT_STAFF,
        method: REQUEST_METHOD.POST,
    },
};
