import { CategorizationCategoryMeta } from '../../models/tag';

export enum ChatHistoryItemType {
    COMMON_MESSAGE = 'common_message',
    MEDIA_RESOURCES = 'media_resources',
    CREATED_CHAT = 'created_chat',
    CLOSED_CHAT = 'chat_closed',
    BONUS = 'bonus',
    NOTE = 'note',
    SEPARATOR = 'separator',
    DEEP_HISTORY = 'deep_history',
    CLASSIFY = 'classify',
}

export enum DEEP_HISTORY_ACTION_TYPES {
    SET_PERFORMER = 'set_performer',
    DROP_PERFORMER = 'drop_performer',
    EVOLVE = 'evolve',
    ADD = 'add',
}

export enum EVOLVE_TAGS {
    CONTAINER_TAG = 'container_tag',
    LONG_TERM_PREPARATION = 'long_term_preparation',
}

export enum CLASSIFICATION_ACTIONS {
    ADD = 'add',
    REMOVE = 'remove',
}

export enum MESSAGE_TYPE {
    WELCOME_TEXT = 'welcome_text',
    PLAINTEXT = 'plaintext',
    ORDER = 'order',
    STICKER = 'sticker',
    LOCATION = 'location',
    CREDIT_CARD = 'CreditCardBinding',
    BONUS = 'bonus',
    SEPARATOR = 'separator',
    MEDIA_RESOURCES = 'media_resources',
    FINE = 'fine',

    USER_DOCUMENTS_PHOTOS = 'user_document_photos',
    USER_DOCUMENTS_PHOTO = 'user_document_photo',
    IMAGE = 'image',
    IMAGE_LINK = 'image_link'
}

export enum StickerDialogTabs {
    STICKERS = 'stickers',
    EMOJI = 'emoji'
}

export interface IChatHistoryItem {
    timestamp: number;
    type: ChatHistoryItemType;
    content?: any;
    user?: any;
    isRobot?: boolean;
    historyAction?: string;
}

export interface ITreeData {
    children: ITreeData[];
    id: string;
    meta: CategorizationCategoryMeta;
    parent_ids: string[];
}

export interface IStickersArray {
    id: string;
    is_active: boolean;
    position: number;
    url: string;
}
