import moment from 'moment';

import { EMPTY_DATA, ONE_MINUTE, ONE_SECOND, ROBOT_FRONTEND, STAFF_ONLY } from '../../constants';
import UserInfo, { UserInfoHandler } from '../../models/user';
import { MESSAGE_TYPE } from './types';

export function getChatMetaInfo(originator, messages, waitingTime) {
    const supportMessages: any = [];
    const originatorMessages: any = [];

    messages?.forEach(el => {
        const isNote = el.traits?.includes(STAFF_ONLY);
        const additionalMessages = el.author == ROBOT_FRONTEND || el.author == originator;
        const isSeparator = el.type === MESSAGE_TYPE.SEPARATOR;

        if (!additionalMessages && !isNote && !isSeparator) {
            supportMessages.push(el);
        }

        if (el.author === originator) {
            originatorMessages.push(el);
        }
    });

    const lastMessageTime = originatorMessages[originatorMessages.length - 1]?.timestamp;
    const isLongWaiting = lastMessageTime * ONE_SECOND + waitingTime * ONE_MINUTE <= +new Date();

    return {
        isLongWaiting,
        isAnswered: Boolean(supportMessages.length),
    };
}

export function matchWelcomeTime(variants, timeForTest?: number) {
    const NOW = timeForTest ? timeForTest : Math.round(+moment() / ONE_SECOND);

    const item = variants?.find(el => {
        const isNight = +el.since > +el.until;
        const START_INTERVAL = Math.round(+moment().set('hour', el.since) / ONE_SECOND);
        const END_INTERVAL = Math.round(+moment().set('hour', el.until) / ONE_SECOND);

        if (isNight) {
            return NOW >= START_INTERVAL || NOW < END_INTERVAL;
        }

        return NOW >= START_INTERVAL && NOW < END_INTERVAL;
    });

    return item?.welcome || '';
}

export function stringHasNumber(string) {
    const isNumberRegExp = new RegExp(/(\s|\D|^)\d{11}(\s|\D|$)/ig);

    return Boolean(string.match(isNumberRegExp));
}

export const GET_OPTION_DESC = (options: any, currentOption: string) => {
    const fullItem = options.find(item => {
        return item.value === currentOption;
    }) || {};

    return fullItem?.selectedDisplayText ?? EMPTY_DATA;
};

export function copySessionText(user: UserInfo, carNumber?: string): string {
    const uih = UserInfoHandler;
    const userPhone = uih.getPhone.call(user);
    const userId = uih.getId.call(user);

    return `${userPhone.replace('+', '')} `
        + `${'`' + userId + '`'} ${uih.getUserLink(userId)} ${carNumber ? ` **${carNumber}** ` : '' }`;
}
