import React, { useState } from 'react';

import { ClassificationType } from '../../../types';
import { LabelTag } from './helpers';
import style from './index.css';
import { NChats } from './types';
import ICategory = NChats.ICategory;
import ClassificationDialog from '../Chats/ClassificationDialog';

interface IChatHeaderClassificationProps {
    classificationData: ICategory[];
    classificationParams: IClassificationParams;
    getClassification?: (tagId: string) => void;
    type?: ClassificationType;
    keyword?: string;
}

export interface IClassificationParams {
    tag_id: string;
    chat_id: string;
    user_id: string;
}

export const ChatHeaderClassification = React.memo((props: IChatHeaderClassificationProps) => {
    const { classificationData, classificationParams, type, keyword } = props;
    const [openClassification, setOpenClassification] = useState<boolean>(false);

    function onClassify() {
        props.getClassification?.(classificationParams.tag_id);
        setOpenClassification(false);
    }

    return <>
        <span onClick={setOpenClassification.bind(null, true)}>

            {classificationData?.map((item: any, index) => {
                return <LabelTag label={item?.category?.meta?.label}
                                 key={index}
                                 className={style.classification}/>;
            })}

            <LabelTag label={'...'} className={style.classification}/>

        </span>

        {openClassification
            ? <ClassificationDialog chat_id={classificationParams.chat_id}
                                    tag_id={classificationParams.tag_id}
                                    user_id={classificationParams.user_id}
                                    type={type ?? ClassificationType.chat}
                                    keyword={keyword}
                                    onClassified={onClassify.bind(null)}
                                    onClose={setOpenClassification.bind(null, false)}/>
            : null
        }
    </>;
});
