import { getFavIcons } from '../Content/getFavIcons';
import { FAV_LINES_TYPES } from '../FavouritesLines';

export class ChatNotification {
    favChat = getFavIcons()?.favChat;
    type: FAV_LINES_TYPES;

    notify(line: string, type: FAV_LINES_TYPES) {
        this.type = type;
        const title = `Драйв`;
        const options = {
            body: `новый чатик в "${line}" `,
            icon: this.favChat,
            image: this.favChat,
            silent: false,
        };

        if ('Notification' in window && document.hidden) {
            if (Notification.permission === 'granted') {
                this._showNotify(title, options, line);
            } else if (Notification.permission !== 'denied') {
                Notification.requestPermission((permission) => {
                    if (permission === 'granted') {
                        this._showNotify(title, options, line);
                    }
                });
            }
        }
    }

    _showNotify(title, options, line) {
        const notification = new Notification(title, options);
        notification.onclick = this._clickNotify.bind(this, line);
    }

    _clickNotify(line, event) {
        const type = this.type === FAV_LINES_TYPES.dispatcher ? 'outgoing' : 'chats';
        const link = `#/${type}/`;
        window.focus();
        parent.focus();
        event.target.close();

        if (!location.href.includes(type)) {
            if (confirm(`Есть новый чатик, за которым вы следите.\n[${line}]\nОткрыть в новом окне?`)) {
                window.open(link);
            } else {
                location.href = link;
            }
        }
    }
}
