import React, { ReactNode } from 'react';

import { Dict } from '../../../../../types';
import { CopyIcon } from '../../../../ui/CopyIcon';
import { IconTaxi } from '../../../../ui/Icons';
import { NChats } from '../../types';
import { CommonMessageFooter } from '../CommonMessageFooter';
import { CommonMessageHeader } from '../CommonMessageHeader';
import style from '../index.css';

interface ICommonMessageContainerProps {
    href: string;
    chatLinkText: string;
    isStaffOnly: boolean;
    isSafeMode: boolean;
    isViewedMessage: boolean;
    isOriginator: boolean;
    isRobot: boolean;
    isSelected: boolean;
    extraError: Error | null;
    changeSelectedMessages: (id: number) => void;
    removeMessage: () => void;
    replaceMessage: () => void;
    children: ReactNode;
    author: Dict<any>;
    chat: NChats.ISelectedChatData;
    item: NChats.ITopicMessageItem;
}

export const MESSAGE_STATUSES = {
    sent: 'Отправлено или внешнее',
    forwarded: 'Перенесено в другую очередь',
    undefined: 'Что-то пошло не так',
};

export const CommonMessageContainer = React.memo((props: ICommonMessageContainerProps) => {
    return <div className={`${style.component} `
    + ` ${props.isOriginator ? style.originator : ''}`
    + ` ${props.isRobot ? style.info : ''}`
    + ` ${props.isStaffOnly ? style.staff_only : ''}`
    }>
        <CommonMessageHeader author={props.author}
                             href={props.href}
                             isOriginator={props.isOriginator}
                             isStaffOnly={props.isStaffOnly}
                             isSafeMode={props.isSafeMode}/>

        {props.extraError
            ? <div className={style.extra_error}>
                <h4>поехала вёрстка (возможно) <CopyIcon text={props.chatLinkText}
                                                         internalTooltipId={'wrong-bb-copy-tooltip'}
                                                         title={'Скопировать ID в буфер'}/>
                </h4>
                <div>
                    {props.item?.text}
                </div>
            </div>
            : <div className={style.content}>{props.children}</div>
        }

        <CommonMessageFooter isViewedMessage={props.isViewedMessage}
                             isOriginator={props.isOriginator}
                             chat={props.chat}
                             isRobot={props.isRobot}
                             item={props.item}
                             isSelected={props.isSelected}
                             changeSelectedMessages={props.changeSelectedMessages}
                             removeMessage={props.removeMessage}
                             replaceMessage={props.replaceMessage}/>

        {props.item?.external_status
            ? <div className={style.additional_footer}>
                <IconTaxi/>
                <span>
                    <i>{MESSAGE_STATUSES[props.item?.external_status] ?? props.item?.external_status}
                        (<span className={style.success_status}>
                            {props.item?.external_status}
                        </span>)
                    </i>
                </span>
            </div>
            : null
        }
    </div>;
});
