import * as React from 'react';

import { ONE_SECOND } from '../../../../constants';
import FormatDate from '../../../../ui/FormatDate';
import { Link } from '../../../../ui/Link';
import { NChats } from '../../types';
import style from '../index.css';

interface ICommonMessageFooterProps {
    isRobot: boolean;
    isOriginator: boolean;
    isViewedMessage: boolean;
    chat: NChats.ISelectedChatData;
    item: NChats.ITopicMessageItem;

    isSelected: boolean;
    changeSelectedMessages: (id: number) => void;

    removeMessage: () => void;
    replaceMessage: () => void;
}

export const CommonMessageFooter = React.memo((props: ICommonMessageFooterProps) => {
    return <>
        {!props.isRobot
            ? <div className={style.footer}>
                <div className={style.footer_status}>
                    {!props.isOriginator
                        ? <ReadStatus user_last_viewed={props.chat?.user_last_viewed} id={props.item?.id}/>
                        : null
                    }
                    <div><FormatDate value={props.item?.timestamp * ONE_SECOND}/></div>
                </div>

                <div className={style.footer_controls}>
                    {!props.isOriginator && !props.isViewedMessage
                        ? <div>
                            <Link onClick={props.removeMessage.bind(null)}>Удалить</Link>
                        </div>
                        : null
                    }
                    {props.isOriginator
                        ? <div className={style.footer_control_wrapper}>
                            <Link onClick={props.replaceMessage.bind(null)} className={style.bank_link}>
                                Банковские данные?
                            </Link>

                            <div className={`${style.select_message} ${props.isSelected
                                ? style.active
                                : style.passive}`}
                                 onClick={props.changeSelectedMessages.bind(null)}/>
                        </div>
                        : null
                    }
                </div>
            </div>
            : null
        }
    </>;
});

export interface IReadStatusProps {
    user_last_viewed: number;
    id: number;
}

export const isViewed = (props: IReadStatusProps) => {
    const { user_last_viewed, id } = props;

    return user_last_viewed >= id;
};

const ReadStatus = React.memo((props: IReadStatusProps) => {
    return <div className={`${style.read_status} ${isViewed(props) ? style.read : style.unread}`}/>;
});
