import * as React from 'react';

import { Dict } from '../../../../../types';
import { UserInfoHandler } from '../../../../models/user';
import { Link } from '../../../../ui/Link';
import { CustomSettings } from '../../../../utils/customSettings';
import style from '../index.css';

interface ICommonMessageHeaderProps {
    author: string | object;
    href: string;
    isOriginator: boolean;
    isStaffOnly: boolean;
    isSafeMode: boolean;
}

export const CommonMessageHeader = React.memo((props: ICommonMessageHeaderProps) => {
    const customSettings: Dict<boolean> | null = new CustomSettings().getSettings();
    const showUserNameInMessages = customSettings?.showUserNameInMessages;
    let author = UserInfoHandler.getPrintName.call(props.author);
    if (typeof props.author === 'string') {
        author = props.author;
    }

    return <>
        {showUserNameInMessages || !props.isOriginator
            ? <div className={style.header_info}>
                <div className={`${props.isSafeMode ? style.safe_mode : ''} ${style.author}`}>
                    <strong>{author}</strong> &nbsp;
                </div>
                <Link href={props.href}> Архив </Link>
            </div>
            : null
        }

        {props.isStaffOnly
            ? <div className={style.note_marker}>ЗАМЕТКА:</div>
            : null}
    </>;
});
