import React from 'react';
import { connect } from 'react-redux';

import { Dict } from '../../../types';
import { GVARS_INTERFACE_ADMIN_PREFIX } from '../../constants';
import { Button, ButtonTypes } from '../../ui/Button';
import { getRawSetting } from '../../utils/getRawSetting';
import { IStore } from '../App/store';
import { chat_defer_until } from '../InterfaceAdminConfig/adminConfigKeys';
import { DeferModal } from './DeferChatModal/component';

const ADMIN_DATA = `${GVARS_INTERFACE_ADMIN_PREFIX}.${chat_defer_until}`;

interface IDeferChatUntilProps {
    onDeferred: () => void;
    selectedChatItem: any;
    defer_until?: Dict<any>;
}

interface IDeferChatUntilState {
    modalIsOpen: boolean;
}

class DeferChatUntil extends React.Component<IDeferChatUntilProps, IDeferChatUntilState> {
    state = {
        modalIsOpen: false,
    };

    showModal(modalIsOpen) {
        this.setState({
            modalIsOpen,
        });
    }

    render() {
        const tag = this.props.selectedChatItem?.tag_data?.tag;
        const config = this.props.defer_until?.[tag] || {};

        return <>
            {
                config.enabled &&
                <Button colorType={ButtonTypes.warning} onClick={this.showModal.bind(this, true)}>Отложить до</Button>
            }

            {
                this.state.modalIsOpen
                && <DeferModal onClose={this.showModal.bind(this, false)}
                               config={config}
                               onDeferred={this.props?.onDeferred.bind(this)}
                               selectedChatItem={this.props.selectedChatItem}/>
            }
        </>;
    }
}

export const mapStateToProps = (store: IStore) => {
    let defer_until = getRawSetting(store, ADMIN_DATA) || [];
    if (defer_until.length) {
        defer_until = defer_until.reduce((_p, _c) => {
            if (!_p.hasOwnProperty(_c.queue)) {
                _p[_c.queue] = _c;
            }

            return _p;
        }, {});
    } else {
        defer_until = null;
    }

    return {
        defer_until,
    };
};

export default connect<any>(mapStateToProps)(DeferChatUntil);
