import React from 'react';
import VirtualList from 'react-tiny-virtual-list';

import { useWindowResize } from '../../hooks/useWindowResize';
import { NoInformation } from '../../ui/NoInformation';
import Spin from '../Spin';
import { FEED_ITEM_SIZE } from './constants';
import style from './index.css';

const OUTGOING_MARK = 'outgoing_communication';

export const FeedList = React.memo((props: any) => {
    const window = useWindowResize();

    return <div className={style.content}>
        {props.isLoading
            ? <Spin/>
            : !props.data?.length
                ? <NoInformation/>
                : <VirtualList width={'100%'}
                               height={window.height}
                               itemCount={props.data.length}
                               itemSize={FEED_ITEM_SIZE}
                               className={style.list}
                               renderItem={({ index, style }) => {
                                   const item = props.data?.[index];
                                   const isOutgoing = item?.id?.includes(OUTGOING_MARK);
                                   const markOutgoing = props.markOutgoing && isOutgoing;
                                   const FeedListItem = props.feedListItem;

                                   return <FeedListItem item={item}
                                                        style={style}
                                                        key={index}
                                                        markOutgoing={markOutgoing}
                                                        users={props.users}
                                                        selectedChatItem={props.selectedChatItem}
                                                        selectChatItem={props.selectChatItem}/>;
                               }}/>
        }
    </div>;
});
