import { connect } from 'react-redux';

import { NAVIGATION } from '../../../utils/navigation';
import { IStore } from '../../App/store';
import { NChats } from '../types';
import IChatListItem = NChats.IChatListItem;
import { getSelectedChatItem } from '../../../reducers/chatReducer/getters';
import { selectChatItem } from '../../../reducers/chatReducer/setters';
import { FeedListItem } from './component';

export interface IFeedListItemStateToProps extends IStore {
    selectedChatItem?: IChatListItem;
    rawSettings?: any[];
}

export interface IFeedListItemDispatchToProps {
    selectChatItem?: (item) => void;
}

export const mapStateToProps = (store: IStore): IFeedListItemStateToProps => {
    return {
        selectedChatItem: getSelectedChatItem(store),
    };
};

export function mapDispatchToProps(dispatch: any): IFeedListItemDispatchToProps {
    return {
        selectChatItem: (item) => {
            location.hash = NAVIGATION.ROUTES.CHATS.uri;
            dispatch(selectChatItem(item));
        },
    };
}

export default connect<IFeedListItemStateToProps, IFeedListItemDispatchToProps, {}>(
    mapStateToProps,
    mapDispatchToProps,
)(FeedListItem);
